/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.ItemStorage;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomRecipeProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;

    public CustomRecipeProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        this.registerRecipes(recipe -> {
            if (!set.add(recipe.func_200442_b())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.func_200442_b());
            }
            CustomRecipeProvider.saveRecipe(cache, recipe.func_200441_a(), path.resolve("data/" + recipe.func_200442_b().func_110624_b() + "/crafterrecipes/" + recipe.func_200442_b().func_110623_a() + ".json"));
        });
    }

    private static void saveRecipe(DirectoryCache cache, JsonObject jsonObject, Path recipeJson) {
        try {
            String json = GSON.toJson((JsonElement)jsonObject);
            String hash = field_208307_a.hashUnencodedChars((CharSequence)json).toString();
            if (!Objects.equals(cache.func_208323_a(recipeJson), hash) || !Files.exists(recipeJson, new LinkOption[0])) {
                Files.createDirectories(recipeJson.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(recipeJson, new OpenOption[0]);){
                    bufferedwriter.write(json);
                }
            }
            cache.func_208316_a(recipeJson, hash);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save recipe {}", (Object)recipeJson, (Object)ioexception);
        }
    }

    @NotNull
    public String func_200397_b() {
        return "CustomRecipes";
    }

    protected abstract void registerRecipes(Consumer<IFinishedRecipe> var1);

    public static class CustomRecipeBuilder {
        private final JsonObject json = new JsonObject();
        private final ResourceLocation id;
        private Block intermediate = Blocks.field_150350_a;

        private CustomRecipeBuilder(String crafter, String id) {
            this.json.addProperty("type", "recipe");
            this.json.addProperty("crafter", crafter);
            this.id = new ResourceLocation("minecolonies", crafter + "/" + id);
        }

        @NotNull
        public static CustomRecipeBuilder create(String crafter, String id) {
            return new CustomRecipeBuilder(crafter, id);
        }

        @NotNull
        public CustomRecipeBuilder inputs(@NotNull List<ItemStorage> inputs) {
            this.json.add("inputs", (JsonElement)this.storageAsJson(inputs));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder result(@NotNull ItemStack result) {
            this.json.addProperty("result", result.func_77973_b().getRegistryName().toString());
            if (result.func_190916_E() != 1) {
                this.json.addProperty("count", (Number)result.func_190916_E());
            }
            return this;
        }

        @NotNull
        public CustomRecipeBuilder lootTable(@NotNull ResourceLocation lootTable) {
            this.json.addProperty("loot-table", lootTable.toString());
            return this;
        }

        @NotNull
        public CustomRecipeBuilder secondaryOutputs(@NotNull List<ItemStack> secondary) {
            this.json.add("additional-output", (JsonElement)this.stackAsJson(secondary));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder alternateOutputs(@NotNull List<ItemStack> alternates) {
            this.json.add("alternate-output", (JsonElement)this.stackAsJson(alternates));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder intermediate(@NotNull Block intermediate) {
            this.intermediate = intermediate;
            return this;
        }

        @NotNull
        public CustomRecipeBuilder minResearchId(@NotNull ResourceLocation researchId) {
            this.json.addProperty("research-id", researchId.toString());
            return this;
        }

        @NotNull
        public CustomRecipeBuilder maxResearchId(@NotNull ResourceLocation researchId) {
            this.json.addProperty("not-research-id", researchId.toString());
            return this;
        }

        @NotNull
        public CustomRecipeBuilder minBuildingLevel(int level) {
            this.json.addProperty("min-building-level", (Number)level);
            return this;
        }

        @NotNull
        public CustomRecipeBuilder maxBuildingLevel(int level) {
            this.json.addProperty("max-building-level", (Number)level);
            return this;
        }

        @NotNull
        public CustomRecipeBuilder mustExist(boolean value) {
            this.json.addProperty("must-exist", Boolean.valueOf(value));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder showTooltip(boolean value) {
            this.json.addProperty("show-tooltip", Boolean.valueOf(value));
            return this;
        }

        public void build(@NotNull Consumer<IFinishedRecipe> consumer) {
            this.json.addProperty("intermediate", this.intermediate.getRegistryName().toString());
            consumer.accept(new Result(this.json, this.id));
        }

        @NotNull
        private JsonArray stackAsJson(List<ItemStack> itemStacks) {
            JsonArray jsonItemStacks = new JsonArray();
            for (ItemStack itemStack : itemStacks) {
                JsonObject jsonItemStack = new JsonObject();
                String name = itemStack.func_77973_b().getRegistryName().toString();
                if (itemStack.func_77942_o() && !itemStack.func_77984_f()) {
                    name = name + itemStack.func_77978_p().toString();
                }
                jsonItemStack.addProperty("item", name);
                if (itemStack.func_190916_E() != 1) {
                    jsonItemStack.addProperty("count", (Number)itemStack.func_190916_E());
                }
                jsonItemStacks.add((JsonElement)jsonItemStack);
            }
            return jsonItemStacks;
        }

        @NotNull
        private JsonArray storageAsJson(List<ItemStorage> itemStorages) {
            JsonArray jsonItemStorages = new JsonArray();
            for (ItemStorage itemStorage : itemStorages) {
                ItemStack stack = itemStorage.getItemStack();
                JsonObject jsonItemStorage = new JsonObject();
                String name = stack.func_77973_b().getRegistryName().toString();
                if (stack.func_77942_o() && !stack.func_77984_f()) {
                    name = name + stack.func_77978_p().toString();
                }
                jsonItemStorage.addProperty("item", name);
                if (itemStorage.ignoreNBT()) {
                    jsonItemStorage.addProperty("matchType", "ignore");
                }
                if (itemStorage.getAmount() != 1) {
                    jsonItemStorage.addProperty("count", (Number)itemStorage.getAmount());
                }
                jsonItemStorages.add((JsonElement)jsonItemStorage);
            }
            return jsonItemStorages;
        }

        private static class Result
        implements IFinishedRecipe {
            final JsonObject json;
            final ResourceLocation id;

            public Result(JsonObject json, ResourceLocation id) {
                this.json = json;
                this.id = id;
            }

            @NotNull
            public JsonObject func_200441_a() {
                return this.json;
            }

            @NotNull
            public ResourceLocation func_200442_b() {
                return this.id;
            }

            public void func_218610_a(@NotNull JsonObject json) {
            }

            public IRecipeSerializer<?> func_218609_c() {
                return null;
            }

            @Nullable
            public JsonObject func_200440_c() {
                return null;
            }

            @Nullable
            public ResourceLocation func_200443_d() {
                return null;
            }
        }
    }
}

